(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6976,        215]
NotebookOptionsPosition[      5254,        179]
NotebookOutlinePosition[      5679,        196]
CellTagsIndexPosition[      5636,        193]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Q", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.971877196343828*^9, 3.971877216400783*^9}},
 CellLabel->
  "In[143]:=",ExpressionUUID->"364cda9d-9169-40d7-b38f-5051f77210c1"],

Cell["Ecuaci\[OAcute]n vectorial", "Text",
 CellChangeTimes->{{3.971877221931786*^9, 
  3.9718772282480907`*^9}},ExpressionUUID->"fc5af9b3-1d52-46f0-8bbf-\
1709c51b570b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P", "+", 
  RowBox[{"t", " ", 
   RowBox[{"(", 
    RowBox[{"Q", "-", "P"}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.971877234926106*^9, 3.971877238272729*^9}, {
  3.971877439565179*^9, 3.971877444590706*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"5b44c621-e9de-422a-aeb2-80a47948bb1c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"3", " ", "t"}]}], ",", 
   RowBox[{"2", "-", 
    RowBox[{"3", " ", "t"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"4", " ", "t"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.971877239125696*^9, 3.971877244313314*^9}, 
   3.971877445301935*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"43f22119-649a-45e6-b913-8d3a4075cd1f"]
}, Open  ]],

Cell["Verificar el punto R", "Text",
 CellChangeTimes->{{3.971877221931786*^9, 
  3.971877256692236*^9}},ExpressionUUID->"d0829255-111f-4879-8b41-\
243cba10ee02"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     RowBox[{"-", "4"}], ",", "7"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"R", "-", "P"}], "==", 
    RowBox[{"\[Alpha]", " ", 
     RowBox[{"(", 
      RowBox[{"Q", "-", "P"}], ")"}]}]}], ",", "\[Alpha]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.97187726159743*^9, 3.971877338940772*^9}},
 CellLabel->
  "In[148]:=",ExpressionUUID->"1960d2dd-dba1-4d75-af3b-16ef2a23100d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"\[Alpha]", "\[Rule]", "2"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.971877298335183*^9, 3.971877339819463*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"f68a41e2-ece5-46f0-9e00-805222cd6fab"]
}, Open  ]],

Cell["Punto medio", "Text",
 CellChangeTimes->{{3.971877221931786*^9, 3.971877256692236*^9}, {
  3.971877359583296*^9, 
  3.971877363915653*^9}},ExpressionUUID->"e95bd7b4-6476-45a3-ab83-\
d7117ed434d6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"P", "+", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{"Q", "-", "P"}], ")"}]}]}], "/.", 
  RowBox[{"t", "->", 
   RowBox[{"1", "/", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.971877373878039*^9, 3.971877383023858*^9}, 
   3.971877453792459*^9},
 CellLabel->
  "In[153]:=",ExpressionUUID->"43f4551f-3376-4542-b992-d4c3651a593a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", 
   FractionBox["1", "2"], ",", "1"}], "}"}]], "Output",
 CellChangeTimes->{{3.971877377482894*^9, 3.9718773842408323`*^9}, 
   3.971877455680264*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"dd31f57b-cbfd-42a4-84de-7c3ad2479d55"]
}, Open  ]],

Cell["Puntos que trisecan", "Text",
 CellChangeTimes->{{3.971877221931786*^9, 3.971877256692236*^9}, {
  3.971877359583296*^9, 3.971877363915653*^9}, {3.97187746866712*^9, 
  3.971877471232791*^9}},ExpressionUUID->"a162f437-57fb-48d6-a67d-\
f24ff4087d73"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "+", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{"Q", "-", "P"}], ")"}]}]}], "/.", 
  RowBox[{"t", "->", 
   RowBox[{"1", "/", "3"}]}]}], "\n", 
 RowBox[{
  RowBox[{"P", "+", 
   RowBox[{"t", " ", 
    RowBox[{"(", 
     RowBox[{"Q", "-", "P"}], ")"}]}]}], "/.", 
  RowBox[{"t", "->", 
   RowBox[{"2", "/", "3"}]}]}]}], "Input",
 CellChangeTimes->{{3.971877221931786*^9, 3.971877256692236*^9}, {
  3.971877359583296*^9, 3.971877363915653*^9}, {3.971877477641684*^9, 
  3.971877508297552*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"64cf8efb-cb93-4cf4-bcce-91b791815b4d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", 
   FractionBox["1", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.971877509898675*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"f834789f-3277-41f6-ad19-c42a4df20c8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "0", ",", 
   FractionBox["5", "3"]}], "}"}]], "Output",
 CellChangeTimes->{3.971877509899618*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"697520d8-cb08-447c-aee3-7fec7403a3e2"]
}, Open  ]]
},
WindowSize->{1086, 644},
WindowMargins->{{96, Automatic}, {Automatic, 59}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 446, 13, 124, "Input",ExpressionUUID->"364cda9d-9169-40d7-b38f-5051f77210c1"],
Cell[1007, 35, 170, 3, 84, "Text",ExpressionUUID->"fc5af9b3-1d52-46f0-8bbf-1709c51b570b"],
Cell[CellGroupData[{
Cell[1202, 42, 319, 8, 73, "Input",ExpressionUUID->"5b44c621-e9de-422a-aeb2-80a47948bb1c"],
Cell[1524, 52, 425, 13, 83, "Output",ExpressionUUID->"43f22119-649a-45e6-b913-8d3a4075cd1f"]
}, Open  ]],
Cell[1964, 68, 162, 3, 84, "Text",ExpressionUUID->"d0829255-111f-4879-8b41-243cba10ee02"],
Cell[CellGroupData[{
Cell[2151, 75, 521, 15, 156, "Input",ExpressionUUID->"1960d2dd-dba1-4d75-af3b-16ef2a23100d"],
Cell[2675, 92, 257, 6, 83, "Output",ExpressionUUID->"f68a41e2-ece5-46f0-9e00-805222cd6fab"]
}, Open  ]],
Cell[2947, 101, 202, 4, 84, "Text",ExpressionUUID->"e95bd7b4-6476-45a3-ab83-d7117ed434d6"],
Cell[CellGroupData[{
Cell[3174, 109, 371, 11, 73, "Input",ExpressionUUID->"43f4551f-3376-4542-b992-d4c3651a593a"],
Cell[3548, 122, 304, 8, 104, "Output",ExpressionUUID->"dd31f57b-cbfd-42a4-84de-7c3ad2479d55"]
}, Open  ]],
Cell[3867, 133, 255, 4, 84, "Text",ExpressionUUID->"a162f437-57fb-48d6-a67d-f24ff4087d73"],
Cell[CellGroupData[{
Cell[4147, 141, 625, 19, 124, "Input",ExpressionUUID->"64cf8efb-cb93-4cf4-bcce-91b791815b4d"],
Cell[4775, 162, 230, 6, 104, "Output",ExpressionUUID->"f834789f-3277-41f6-ad19-c42a4df20c8f"],
Cell[5008, 170, 230, 6, 104, "Output",ExpressionUUID->"697520d8-cb08-447c-aee3-7fec7403a3e2"]
}, Open  ]]
}
]
*)

